/* $Id: srcarbtest.c,v 1.8 1998/07/22 23:49:54 ericb Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Don Mathiesen */

#include <stdlib.h>		/* For exit */
#include <stdio.h>		/* For printf */
#include <string.h>		/* For strcmp */
#include "e1432.h"
#include "xplot.h"

#define SIZE 16384

/* #define DPRINT  */
/* #define DPRINT1 */

/* Wrap this around all the many function calls which might fail */
#define	DEBUG(s)	s
#ifdef	__lint
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (func)
#else
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (0)
#endif

#define WIDTH           500
#define HEIGHT          400

static LONGSIZ32 src_buff[E1432_SRC_DATA_NUMWORDS_MAX];

#define SIG_LENGTH_MAX 100000

static LONGSIZ32 src_sigbuff[SIG_LENGTH_MAX];
static LONGSIZ32 *src_sigbuffptr;
static LONGSIZ32 *src_siglast;
static LONGSIZ32 arb_sigperiod;
static LONGSIZ32 arb_siglength;
static SHORTSIZ16 sigtype;

static long src_arb_val = 0;
static int rd4data_set_count, rd4data_clr_count;

void 
prompt(char *promptstr)
{
    char    tmp_str[1024];

    (void) printf(promptstr);
    (void) gets(tmp_str);
}

void
src_sig(LONGSIZ32 period, SHORTSIZ16 type)
{
    LONGSIZ32 i, src_arb_inc;

#ifdef DPRINT
    (void) printf("src_sig: period = %d, type = %d\n", period, type);
#endif

    if (arb_siglength > SIG_LENGTH_MAX)
	arb_siglength = SIG_LENGTH_MAX;

    switch (type)
    {
    case 1:
    default:
	/* sawtooth */
	src_arb_inc = -2 * ((LONGSIZ32) 0x80000000 / period);
	src_arb_val = 0;
	src_sigbuffptr = src_sigbuff;
	for (i = 0; i < arb_siglength; i++)
	{
	    *src_sigbuffptr = src_arb_val;
	    src_arb_val += src_arb_inc;
	    src_sigbuffptr = src_sigbuffptr + 1;
	}
    }
    src_sigbuffptr = src_sigbuff;
    src_siglast = &src_sigbuffptr[arb_siglength - 1];
}

void
xfr_src_sig(E1432ID hw, SHORTSIZ16 chanID, LONGSIZ32 arb_xfrsize,
	    SHORTSIZ16 mode, LONGSIZ32 numwords)
{
    LONGSIZ32 i, words_left, xfrsize, maxtries;
    LONGSIZ32 *src_buffptr;

    /* copy arb_xfrsize words from src_sigbuff to src_buff, wrapping
       when needed */
#ifdef DPRINT
    (void) printf("xfr_src_sig: arb_xfrsize = %d, mode = %d, numwords = %d\n",
		  arb_xfrsize, mode, numwords);
#endif

    words_left = numwords;
    if (arb_xfrsize > E1432_SRC_DATA_NUMWORDS_MAX)
	arb_xfrsize = E1432_SRC_DATA_NUMWORDS_MAX;

    while (words_left > 0)
    {
	if (words_left < arb_xfrsize)
	    xfrsize = words_left;
	else
	    xfrsize = arb_xfrsize;
	src_buffptr = src_buff;
#ifdef DPRINT
	(void) printf("xfr_src_sig: src_sigbuffptr = %x, "
		      "src_siglast = %x, words_left = %d, xfrsize = %d\n",
		      src_sigbuffptr, src_siglast, words_left, xfrsize);
#endif
	for (i = 0; i < xfrsize; i++)
	{
	    *src_buffptr = *src_sigbuffptr;
#ifdef DPRINT1
	    (void) printf("xfr_src_sig: words_left = %d, "
			  "xfrsize = %d, i = %d\n",
			  words_left, xfrsize, i);
	    (void) printf("xfr_src_sig: * src_sigbuffptr = %x, "
			  "src_sigbuffptr = %x, src_siglast = %x\n",
			  *src_sigbuffptr, src_sigbuffptr, src_siglast);
	    (void) printf("xfr_src_sig: * src_buffptr = %x, "
			  "src_buffptr = %x\n",
			  *src_buffptr, src_buffptr);
#endif
	    if (src_sigbuffptr >= src_siglast)
		src_sigbuffptr = src_sigbuff;
	    else
		src_sigbuffptr = src_sigbuffptr + 1;
	    src_buffptr = src_buffptr + 1;
	}

	/* write  xfrsize words to the substrate */

	i = 0;
	maxtries = 100000;

	for (i = 0; i < maxtries; i++)
	{
	    if (e1432_check_src_arbrdy(hw, chanID, mode) == 1)
	    {
		rd4data_set_count = rd4data_set_count + 1;
		(void) e1432_write_srcbuffer_data(hw, chanID,
						  src_buff,
						  (SHORTSIZ16) xfrsize,
						  mode);
		words_left = words_left - xfrsize;
		break;
	    }
	    else
		rd4data_clr_count = rd4data_clr_count + 1;
	}
	if (i == maxtries)
	    return;
    }
}

#if 0
int
fill_src_arb(E1432ID hw, SHORTSIZ16 chanID, LONGSIZ32 length,
	     LONGSIZ32 arb_xfrsize, SHORTSIZ16 mode)
{
    short   words_written;
    short   rd4data;
    long    src_arb_inc;
    int     i;

    words_written = 0;
    if (arb_xfrsize > E1432_SRC_DATA_NUMWORDS_MAX)
    {
	arb_xfrsize = E1432_SRC_DATA_NUMWORDS_MAX;
#ifdef DPRINT
	(void) printf("fill_src_arb() warning:\n");
	(void) printf("arb_xfrsize = %d reduced to %d\n",
		      arb_xfrsize, E1432_SRC_DATA_NUMWORDS_MAX);
#endif
    }

    if (arb_xfrsize > length)
	arb_xfrsize = length;

    src_arb_inc = 0x40000000 / length * 4;
/*
   CHECK(e1432_get_srcbuffer_rdy4data (hw, chanID, &rd4data));
 */
    rd4data = e1432_check_src_arbrdy(hw, chanID, mode);

#ifdef DPRINT
    (void) printf("fill_src_arb() rd4data = (%x)\n", rd4data);
#endif

    if (rd4data)
	rd4data_set_count = rd4data_set_count + 1;
    else
	rd4data_clr_count = rd4data_clr_count + 1;
    while ((words_written < length) && rd4data)
    {
	if (arb_xfrsize > (length - words_written))
	{
	    arb_xfrsize = length - words_written;
	}
	for (i = 0; i < arb_xfrsize; i++)
	{
	    src_buff[i] = src_arb_val;
	    src_arb_val += src_arb_inc;
	}
#ifdef DPRINT
/*
  (void) printf("fill_src_arb() downloading 0x%x words"
  ", first = 0x%x, last = 0x%x\n",
  arb_xfrsize, src_buff[0], src_buff[arb_xfrsize-1]);
 */
#endif

	CHECK(e1432_write_srcbuffer_data(hw, chanID, src_buff,
					 (SHORTSIZ16) arb_xfrsize,
					 mode));
	words_written += arb_xfrsize;
/*
   CHECK(e1432_get_srcbuffer_rdy4data (hw, chanID, &rd4data));
 */
	rd4data = e1432_check_src_arbrdy(hw, chanID, mode);
	if (rd4data)
	    rd4data_set_count = rd4data_set_count + 1;
	else
	    rd4data_clr_count = rd4data_clr_count + 1;
    }


    return 0;
}
#endif

int
main(int argn, char **argv)
{
    int     opt;		/* really char returned */
    int     rtn;
    float   ftmp;
    int     i, status, nchan;
    struct e1432_hwconfig hwconfig;
    FLOATSIZ64 buffer[SIZE];
    LONGSIZ32 count;
    SHORTSIZ16 laddr = 8;
    SHORTSIZ16 chan_list[32];
    SHORTSIZ16 in_group;
    E1432ID hw;

    int     triggered = 0;	/* tach trig if tach, ext otherwise */
    int     source_on = 1;	/* sine unless arb_src = 1 */
    int     arb_src;
    int     passes = 20000;	/* times through the data acq loop */
    SHORTSIZ16 arb_mode = E1432_SRCBUFFER_PERIODIC_A;
    SHORTSIZ16 source_mode = E1432_SOURCE_MODE_SINE;
    LONGSIZ32 blocksize = 1024;

    const float top_span = 20.0E3;
    FLOATSIZ32 span = top_span;
    int     m, data_offset;
    char   *plotid = NULL;
    float   fixed_delay, fract_delay, dec_factor;
    char    geometry[80];
    char    title[80];
    int     row = 0, col = 0;
    float   data[1024];
    int     no = 0;
    int     plot_samples;
    int     plot_width = 8;
    float   plotTop = 5;
    float   plotBottom = -1;
    float   plotRight = (float) plot_width / 2.0;
    float   plotLeft = -plotRight;
    int     pass;

    SHORTSIZ16 tach_trig_chan = 0;
    int     tach_trig = 0;
    SHORTSIZ16 src_chan = 0;
    SHORTSIZ16 lsource[1];
    SHORTSIZ16 src_group = 0;
    SHORTSIZ16 inst_list[33];
    SHORTSIZ16 inst_group = 0;
    int     src_chans = 0;

    int     source_triggered = 0;
    /*FLOATSIZ32 srcblockmin, srcblockmax, srcblockdef, srcblockstep;*/

    int     itmp;
    LONGSIZ32 span_decimation = 1;

    LONGSIZ32 src_blocksize = 0;
    LONGSIZ32 arb_xfrsize = 0;
    LONGSIZ32 arb_srcbufsize = 0;
    LONGSIZ32 arb_srcbufsizemax = 0;
    LONGSIZ32 arb_xfrmode = E1432_SRC_DATA_MODE_A;
    SHORTSIZ16 arb_xfrmodewait = E1432_SRC_DATA_MODE_WAITA;
    LONGSIZ32 numwords = 0;

    arb_siglength = 0;
    arb_sigperiod = 0;
    sigtype = 0;

    /* Initialize library things */
    CHECK(e1432_init_io_driver());
    CHECK(e1432_print_errors(1));
    e1432_trace_level(0);	/* 0 = no trace; >0 arbrd4data trace */
    e1432_debug_level(0);
    /* 
       0= no prints on reg access 1= print on reg reads >=2 = print
       on reg reads and writes */

    while ((opt = getopt(argn, argv,
			 "a:d:hl:s:tu:w:x:y:z:Y:Z:")) != EOF)
    {
	switch (opt)
	{
	case 'a':
	    if (strcmp(optarg, "CONTINUOUS") == 0)
	    {
		arb_mode = E1432_SRCBUFFER_CONTINUOUS;
	    }
	    else if (strcmp(optarg, "PERIODIC_AB") == 0)
	    {
		arb_mode = E1432_SRCBUFFER_PERIODIC_AB;
	    }
	    else if (strcmp(optarg, "PERIODIC_A") == 0)
	    {
		arb_mode = E1432_SRCBUFFER_PERIODIC_A;
	    }
	    else if (strcmp(optarg, "SWITCHEDAUTO") == 0)
	    {
		arb_mode = E1432_SRCBUFFER_SWITCHEDAUTO;
	    }
	    else if (strcmp(optarg, "SWITCHEDCMD") == 0)
	    {
		arb_mode = E1432_SRCBUFFER_SWITCHEDCMD;
	    }
	    else
	    {
		(void) fprintf(stderr, "arb source mode %s not recognized\n",
			       optarg);
		exit(2);
	    }
	    break;
	case 'd':
	    rtn = sscanf(optarg, "%d", &itmp);
	    if (rtn == 1)
	    {
		span_decimation = (LONGSIZ32) (itmp);
	    }
	    else
	    {
		(void) fprintf(stderr, "span decimation %s not converted\n",
			       optarg);
		exit(2);
	    }
	    break;
	case 'l':
	    rtn = sscanf(optarg, "%f", &ftmp);
	    if (rtn == 1)
	    {
		blocksize = (LONGSIZ32) (ftmp + .5);
	    }
	    else
	    {
		(void) fprintf(stderr, "record length %s not converted\n",
			       optarg);
		exit(2);
	    }
	    break;
	case 's':
	    if (strcmp(optarg, "SINE") == 0)
	    {
		source_mode = E1432_SOURCE_MODE_SINE;
	    }
	    else if (strcmp(optarg, "BSINE") == 0)
	    {
		source_mode = E1432_SOURCE_MODE_BSINE;
	    }
	    else if (strcmp(optarg, "RAND") == 0)
	    {
		source_mode = E1432_SOURCE_MODE_RAND;
	    }
	    else if (strcmp(optarg, "BRAND") == 0)
	    {
		source_mode = E1432_SOURCE_MODE_BRAND;
	    }
	    else if (strcmp(optarg, "ARB") == 0)
	    {
		source_mode = E1432_SOURCE_MODE_ARB;
	    }
	    else if (strcmp(optarg, "BARB") == 0)
	    {
		source_mode = E1432_SOURCE_MODE_BARB;
	    }
	    else
	    {
		(void) fprintf(stderr, "source mode %s not recognized\n",
			       optarg);
		exit(2);
	    }
	    break;
	case 't':
	    source_triggered = 1;
	    break;
	case 'w':
	    rtn = sscanf(optarg, "%f", &ftmp);
	    if (rtn == 1)
	    {
		src_blocksize = (LONGSIZ32) (ftmp + .5);
	    }
	    else
	    {
		(void) fprintf(stderr, "source block size %s not converted\n",
			       optarg);
		exit(2);
	    }
	    break;
	case 'x':
	    rtn = sscanf(optarg, "%f", &ftmp);
	    if (rtn == 1)
	    {
		arb_xfrsize = (LONGSIZ32) (ftmp + .5);
	    }
	    else
	    {
		(void) fprintf(stderr, "arb transfer size %s not converted\n",
			       optarg);
		exit(2);
	    }
	    break;
	case 'y':
	    rtn = sscanf(optarg, "%f", &ftmp);
	    if (rtn == 1)
	    {
		arb_srcbufsize = (LONGSIZ32) (ftmp + .5);
	    }
	    else
	    {
		(void) fprintf(stderr,
			       "arb source buffer size %s not converted\n",
			       optarg);
		exit(2);
	    }
	    break;
	case 'z':
	    rtn = sscanf(optarg, "%f", &ftmp);
	    if (rtn == 1)
	    {
		arb_siglength = (LONGSIZ32) (ftmp + .5);
	    }
	    else
	    {
		(void) fprintf(stderr, "arb signal length %s not converted\n",
			       optarg);
		exit(2);
	    }
	    break;
	case 'Y':
	    rtn = sscanf(optarg, "%f", &ftmp);
	    if (rtn == 1)
	    {
		sigtype = ftmp + .5;
	    }
	    else
	    {
		(void) fprintf(stderr, "arb signal period %s not converted\n",
			       optarg);
		exit(2);
	    }
	    break;
	case 'Z':
	    rtn = sscanf(optarg, "%f", &ftmp);
	    if (rtn == 1)
	    {
		arb_sigperiod = (LONGSIZ32) (ftmp + .5);
	    }
	    else
	    {
		(void) fprintf(stderr, "arb signal period %s not converted\n",
			       optarg);
		exit(2);
	    }
	    break;
	default:
	    (void) fprintf(stderr, "%s usage:\n", argv[0]);
	    (void) fprintf(stderr, "         -a { CONTINUOUS | PERIODIC_AB |"
			   " PERIODIC_A | SWITCHEDAUTO | SWITCHEDCMD }\n");
	    (void) fprintf(stderr, "         -d span decimation\n");
	    (void) fprintf(stderr, "         -l block length\n");
	    (void) fprintf(stderr, "         -s { SINE | BSINE | RAND | BRAND"
			   " | ARB | BARB }\n");
	    (void) fprintf(stderr, "         -t (to trigger from source)\n");
	    (void) fprintf(stderr, "         -w source block size\n");
	    (void) fprintf(stderr, "         -x arb transfer size\n");
	    (void) fprintf(stderr, "         -y arb source buffer size\n");
	    (void) fprintf(stderr, "         -z arb signal length\n");
	    (void) fprintf(stderr, "         -Y arb signal type\n");
	    (void) fprintf(stderr, "         -Z arb signal period\n");
	    exit(2);
	}
    }

    arb_src = (source_mode == E1432_SOURCE_MODE_ARB
	       || source_mode == E1432_SOURCE_MODE_BARB);

    CHECK(e1432_assign_channel_numbers(1, &laddr, &hw));

    CHECK(e1432_get_hwconfig(1, &laddr, &hwconfig));

    (void) printf("input_chans = %d, source_chans = %d,"
		  " tach_chans = %d, total_chans = %d\n",
		  hwconfig.input_chans, hwconfig.source_chans,
		  hwconfig.tach_chans, hwconfig.total_chans);

    if (hwconfig.tach_chans > 0 && triggered)
    {
	tach_trig_chan = E1432_TACH_CHAN(hwconfig.tach_chans);
	tach_trig = 1;
    }

    if (hwconfig.source_chans > 0 && source_on)
    {
	src_chans = hwconfig.source_chans;
	src_chan = E1432_SOURCE_CHAN(src_chans);
	lsource[0] = src_chan;
	src_group = e1432_create_channel_group(hw, hwconfig.source_chans,
					       lsource);
	if (src_group >= 0)
	{
	    DEBUG((void) printf("e1432_create_channel_group src_group"
				"returned %d\n", src_group));
	    return -1;
	}
    }
    else
    {
	src_chan = -1;
	arb_src = 0;
    }

    /* Create channel group */
    nchan = hwconfig.input_chans;
    if (nchan > 32)
	nchan = 32;
    for (i = 0; i < nchan; i++)
    {
	inst_list[i] = chan_list[i] = E1432_INPUT_CHAN(i + 1);
    }
    if (src_chan > 0)
	inst_list[i] = src_chan;

    in_group = e1432_create_channel_group(hw, nchan, chan_list);
    if (in_group >= 0)
    {
	DEBUG((void) printf("e1432_create_channel_group in_group "
			    "returned %d\n",
			    in_group));
	return -1;
    }

    inst_group = e1432_create_channel_group(hw, nchan + src_chans, inst_list);
    if (inst_group >= 0)
    {
	DEBUG((void) printf("e1432_create_channel_group inst_group"
			    " returned %d\n",
			    in_group));
	return -1;
    }


    /* Initialize hardware things */
    for (i = 0; i < nchan; i++)
	CHECK(e1432_set_analog_input(hw, chan_list[i],
				     E1432_INPUT_MODE_VOLT,
				     E1432_INPUT_HIGH_NORMAL,
				     E1432_ANTI_ALIAS_ANALOG_ON,
				     E1432_COUPLING_DC, 10.0));
    CHECK(e1432_set_data_size(hw, in_group, E1432_DATA_SIZE_32));
    CHECK(e1432_set_blocksize(hw, in_group, blocksize));

    if (src_chan > 0)
    {
	CHECK(e1432_set_source_mode(hw, src_group, source_mode));
	CHECK(e1432_set_active(hw, src_group, E1432_CHANNEL_ON));
	CHECK(e1432_set_range(hw, src_group, 10.0));
	CHECK(e1432_set_amp_scale(hw, src_group, .5));
	CHECK(e1432_set_filter_freq(hw, src_group, 6400));
	if (src_blocksize == 0)
	    src_blocksize = blocksize;
/*
   CHECK(e1432_get_source_blocksize_limits( hw, src_group, &srcblockmin, &srcblockmax, &srcblockdef, &srcblockstep));
   if (src_blocksize > srcblockmax) src_blocksize = srcblockmax;
 */
	CHECK(e1432_set_blocksize(hw, src_group, src_blocksize));
/*      when implemented:
   CHECK(e1432_set_source_blocksize( hw, src_group, src_blocksize));
 */

/*
   CHECK(e1432_set_ramp_rate( hw, src_group, .005));
 */
	CHECK(e1432_set_ramp_rate(hw, src_group, 0));
	CHECK(e1432_set_duty_cycle(hw, src_group, .5));
	CHECK(e1432_set_sine_freq(hw, src_group, 5000.0));
	CHECK(e1432_set_source_cola(hw, src_group, E1432_SOURCE_COLA_OFF));
	CHECK(e1432_set_source_sum(hw, src_group, E1432_SOURCE_SUM_OFF));
	CHECK(e1432_set_source_output(hw, src_group, E1432_SOURCE_OUTPUT_NORMAL));
	if (source_mode == E1432_SOURCE_MODE_ARB
	    || source_mode == E1432_SOURCE_MODE_BARB)
	{
	    FLOATSIZ32 min, max, def, step;

	    if (arb_siglength == 0)
		arb_siglength = src_blocksize;

	    CHECK(e1432_set_srcbuffer_mode(hw, src_group, arb_mode));
	    CHECK(e1432_get_srcbuffer_size_limits(hw, src_group, &min, &max, &def, &step));
	    arb_srcbufsizemax = (LONGSIZ32) max;
	    switch (arb_mode)
	    {
	    case E1432_SRCBUFFER_PERIODIC_A:
		if (arb_srcbufsize == 0)
		    arb_srcbufsize = arb_siglength;
		if (arb_srcbufsize > arb_srcbufsizemax)
		    arb_srcbufsize
			= arb_srcbufsizemax;
		numwords = arb_srcbufsize;
		arb_xfrmode = E1432_SRC_DATA_MODE_A;
		arb_xfrmodewait = E1432_SRC_DATA_MODE_WAITA;
		break;
	    case E1432_SRCBUFFER_PERIODIC_AB:
		if (arb_srcbufsize == 0)
		    arb_srcbufsize = arb_siglength / 2;
		if (arb_srcbufsize > arb_srcbufsizemax)
		    arb_srcbufsize
			= arb_srcbufsizemax;
		numwords = 2 * arb_srcbufsize;
		arb_xfrmode = E1432_SRC_DATA_MODE_AB;
		arb_xfrmodewait = E1432_SRC_DATA_MODE_WAITAB;
		break;
	    case E1432_SRCBUFFER_CONTINUOUS:
		if (arb_srcbufsize == 0)
		    arb_srcbufsize = src_blocksize;
		if (arb_srcbufsize > arb_srcbufsizemax)
		    arb_srcbufsize
			= arb_srcbufsizemax;
		numwords = 2 * arb_srcbufsize;
		arb_xfrmode = E1432_SRC_DATA_MODE_AB;
		arb_xfrmodewait = E1432_SRC_DATA_MODE_WAITAB;
		break;
	    case E1432_SRCBUFFER_SWITCHEDCMD:
	    case E1432_SRCBUFFER_SWITCHEDAUTO:
		if (arb_srcbufsize == 0)
		    arb_srcbufsize = arb_siglength / 2;
		if (arb_srcbufsize > arb_srcbufsizemax)
		    arb_srcbufsize
			= arb_srcbufsizemax;
		numwords = 2 * arb_srcbufsize;
		arb_xfrmode = E1432_SRC_DATA_MODE_AB;
		arb_xfrmodewait = E1432_SRC_DATA_MODE_WAITAB;
		break;
	    default:
		if (arb_srcbufsize == 0)
		    arb_srcbufsize = src_blocksize;
		if (arb_srcbufsize > arb_srcbufsizemax)
		    arb_srcbufsize
			= arb_srcbufsizemax;
		numwords = arb_srcbufsize;
		arb_xfrmode = E1432_SRC_DATA_MODE_AB;
		arb_xfrmodewait = E1432_SRC_DATA_MODE_WAITAB;
		break;
	    }

	    span = top_span / span_decimation;
	    if (arb_xfrsize == 0)
		arb_xfrsize = arb_srcbufsize;
	    if (arb_xfrsize > E1432_SRC_DATA_NUMWORDS_MAX)
		arb_xfrsize = E1432_SRC_DATA_NUMWORDS_MAX;

	    (void) printf("src_blocksize %d, arb_xfrsize %d, "
			  "arb_srcbufsize %d, arb_siglength %d\n",
			  src_blocksize, arb_xfrsize,
			  arb_srcbufsize, arb_siglength);
	    (void) printf("arb_xfrmode %x, arb_xfrmodewait %d\n",
			  arb_xfrmode, arb_xfrmodewait);
	    CHECK(e1432_set_srcbuffer_size(hw, src_group, arb_srcbufsize));
	    CHECK(e1432_set_srcbuffer_init(hw, src_group,
					   E1432_SRCBUFFER_INIT_EMPTY));

/** create signal array ***/

	    if (arb_sigperiod == 0)
		arb_sigperiod = arb_siglength / 4;
	    sigtype = 1;
	    src_sig(arb_sigperiod, sigtype);
/* down load signal */
	    xfr_src_sig(hw, src_chan, arb_xfrsize, arb_xfrmodewait, numwords);


/*
   fill_src_arb(hw, src_chan, src_sigbuffstart, src_sigbuffptr,
   arb_siglengthptr, arb_xfrsize,arb_xfrmodewait);
 */
	    (void) printf("done pre-loading buffer, turning on\n");
	}
	if (source_triggered)
	{
	    CHECK(e1432_set_trigger_channel(hw, src_group, E1432_CHANNEL_ON));
	    CHECK(e1432_set_auto_arm(hw, src_group, E1432_AUTO_ARM));
	    CHECK(e1432_set_auto_trigger(hw, src_group, E1432_MANUAL_TRIGGER));
	}

	/* 
	   CHECK(e1432_init_measure(hw, src_group));
	   prompt("completed src e1432_init_measure(),hit enter to
	   continue..."); */
    }

    if (triggered)
    {
	char    a_line[1024];
	int     d_passes = 0;

	(void) printf("enter number of decimation passes (default = %d) ",
		      d_passes);
	(void) gets(a_line);
	(void) sscanf(a_line, "%d", &d_passes);
	(void) printf("passes = %d\n", d_passes);
/*         span = top_span; */
	while (d_passes-- > 0)
	    span *= .5;
	(void) printf("enter plot width in samples (default = %d) ",
		      plot_width);
	(void) gets(a_line);
	(void) sscanf(a_line, "%d", &plot_width);
	plot_samples = plot_width + 2;
    }
    if (no)
    {
	prompt("doing e1432_init_measure, hit enter to continue...");
	CHECK(e1432_init_measure(hw, in_group));
	prompt("doing ext clock setup, hit enter to continue...");
	CHECK(e1432_set_auto_group_meas(hw, in_group, E1432_AUTO_GROUP_MEAS_OFF));
	CHECK(e1432_set_clock_freq(hw, in_group, 51200.0));
	CHECK(e1432_set_clock_source(hw, in_group, E1432_CLOCK_SOURCE_EXTERNAL));
	prompt("done with ext clock setup, hit enter to continue...");
    }

    if (triggered && !tach_trig)
    {
	CHECK(e1432_set_auto_arm(hw, in_group, E1432_AUTO_ARM));
	CHECK(e1432_set_trigger_ext(hw, in_group, E1432_TRIGGER_EXT_POS));
	CHECK(e1432_set_auto_trigger(hw, in_group, E1432_MANUAL_TRIGGER));
    }

    if (tach_trig)
    {
	CHECK(e1432_set_auto_arm(hw, in_group, E1432_AUTO_ARM));
	CHECK(e1432_set_trigger(hw, tach_trig_chan, E1432_CHANNEL_ON, 0, 1.0, 2.5, E1432_TRIGGER_SLOPE_POS, E1432_TRIGGER_MODE_LEVEL));
	/* 
	   CHECK(e1432_set_trigger_channel( hw, tach_trig_chan,
	   E1432_CHANNEL_ON)); CHECK(e1432_set_trigger_level( hw,
	   tach_trig_chan,E1432_TRIGGER_LEVEL_LOWER, 1.0));
	   CHECK(e1432_set_trigger_level( hw,
	   tach_trig_chan,E1432_TRIGGER_LEVEL_UPPER, 2.5));
	   CHECK(e1432_set_trigger_slope( hw,
	   tach_trig_chan,E1432_TRIGGER_SLOPE_POS));
	   CHECK(e1432_set_trigger_mode( hw, tach_trig_chan,
	   E1432_TRIGGER_MODE_LEVEL)); CHECK(e1432_set_active(hw,
	   tach_trig_chan, E1432_CHANNEL_ON)); */
	CHECK(e1432_set_auto_trigger(hw, in_group, E1432_MANUAL_TRIGGER));
    }

    CHECK(e1432_set_span(hw, in_group, span));
    CHECK(e1432_set_span(hw, src_group, span));
    if (triggered)
    {
	FLOATSIZ32 actual_span, sample_rate;

	CHECK(e1432_get_span(hw, in_group, &actual_span));
	CHECK(e1432_get_clock_freq(hw, in_group, &sample_rate));
	(void) printf("span = %f, sample rate = %f\n",
		      actual_span, sample_rate);
	dec_factor = sample_rate / 2.56 / actual_span;
	fixed_delay = 33.7;	/* dec_factor = 1 */
	fixed_delay = 30.7 / dec_factor + 3.0;
	data_offset = (int) fixed_delay;
	fract_delay = fixed_delay - (float) data_offset;
	data_offset -= plot_width / 2;
	(void) printf("dec_factor = %f, fract_delay = %f\n",
		      dec_factor, fract_delay);
	(void) printf("fixed_delay = %f, data_offset = %d\n",
		      fixed_delay, data_offset);
    }

    /* Start measurement */
    CHECK(e1432_init_measure(hw, inst_group));
    if (triggered)
    {
	/* needed to fake out the x scaling */
	for (m = 0; m < plot_samples; m += 2)
	{
	    data[2 * m] = plotLeft;
	    data[2 * m + 1] = plotBottom;
	    data[2 * m + 2] = plotRight;
	    data[2 * m + 3] = plotTop;
	}
	(void) sprintf(geometry, "%dx%d+%d+%d", WIDTH, HEIGHT,
		       (WIDTH + 20) * col, (HEIGHT + 40) * row);
	(void) sprintf(title, "Channel %d", 1);
	plotid = xplot_init_plot(&(data[0]), 2 * plot_samples, (float) plot_width,
	       plotTop, plotBottom, GENERIC_TRACE, geometry, title);
	xplot_change_mode(plotid, XY_MODE);
	xplot_change_yautoscale(plotid, 0);
	xplot_change_xautoscale(plotid, 0);
	xplot_set_xscale(plotid, plotLeft, plotRight);
	xplot_set_yscale(plotid, plotTop, plotBottom);
	xplot_change_xlabel(plotid, "Samples");
	xplot_change_ylabel(plotid, "Volts");
	xplot_repaint(plotid);

	/* prompt("hit enter to continue..."); */
	xplot_data_update(plotid);
	/* prompt("hit enter to continue..."); */
    }

    for (pass = 0; pass < passes; pass++)
    {
	rd4data_set_count = 0;
	rd4data_clr_count = 0;

	if (arb_src && (arb_mode == E1432_SRCBUFFER_CONTINUOUS))
	{
	    numwords = arb_xfrsize;
	    for (;;)
	    {
		xfr_src_sig(hw, src_chan, arb_xfrsize,
			    arb_xfrmodewait, numwords);
	    }
/*
   CHECK(fill_src_arb(hw, src_chan, arb_siglength, arb_xfrsize,arb_xfrmode));
 */

#ifdef DPRINT1
	    (void) printf("rd4data_set_count= %d   rd4data_clr_count= %d\n",
			  rd4data_set_count, rd4data_clr_count);
#endif
	}
	if (no)
	{
	    prompt("hit enter to autozero...");
	    (void) printf("auto zeroing, ");
	    CHECK(e1432_auto_zero(hw, in_group));
	    prompt("hit enter to continue...");
	}

	if (no)
	{
	    extern SHORTSIZ16 e1432_get_cal_failures(E1432ID,
						     SHORTSIZ16,
						     LONGSIZ32 *);
	    extern SHORTSIZ16 e1432_get_cal_gain(E1432ID, SHORTSIZ16,
						 FLOATSIZ32 *);
	    extern SHORTSIZ16 e1432_get_cal_offset(E1432ID,
						   SHORTSIZ16,
						   FLOATSIZ32 *);
	    float   cal_gain, cal_offset;
	    long    cal_failures;

	    CHECK(e1432_get_cal_gain(hw, chan_list[i], &cal_gain));
	    CHECK(e1432_get_cal_offset(hw, chan_list[i], &cal_offset));
	    CHECK(e1432_get_cal_failures(hw, chan_list[i], &cal_failures));
	    (void) printf("chan %d, gain = %f, offset = %f, failures = 0x%x\n",
			  i, cal_gain, cal_offset, cal_failures);
	}

	/* Start measurement */
	/* 
	   CHECK(e1432_init_measure(hw, in_group)); */

	/* Wait for block available */
	while ((status = e1432_block_available(hw, in_group)) == 0);
	if (status > 0)
	{
	    if (!triggered)
		(void) printf("Block available found!\n");
	}
	else
	{
	    DEBUG((void) printf("Error %d from e1432_block_available\n",
				status));
	    return -1;
	}

	/* Read some data */
	for (i = 0; i < nchan; i++)
	{

	    CHECK(e1432_read_float64_data(hw, chan_list[i],
					  E1432_TIME_DATA, buffer,
					  blocksize, NULL, &count));
	    if (count != blocksize)
	    {
		DEBUG((void) printf("Actual count was %d\n", count));
		return -1;
	    }

	    /* (void) printf("First four data samples:  %g, %g, %g,
	       %g\n", *buffer, *(buffer + 1), *(buffer + 2), *(buffer 
	       + 3)); */
	}
	/* prompt("hit enter to continue..."); */
    }				/* end for */

    if (src_chan > 0)
    {
	prompt("hit enter to continue on to e1432_set_range()...");
	CHECK(e1432_set_range(hw, src_group, 5.0));
	prompt("hit enter to continue on to e1432_set_sine_freq()...");
	CHECK(e1432_set_sine_freq(hw, src_group, 1000));
	prompt("hit enter to continue on to e1432_set_amp_scale()...");
	CHECK(e1432_set_amp_scale(hw, src_group, .2));
	prompt("hit enter to continue on to e1432_set_sine_phase()...");
	CHECK(e1432_set_sine_phase(hw, src_group, 180));
    }
    return 0;
}
